(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5824,        190]*)
(*NotebookOutlinePosition[      6666,        217]*)
(*  CellTagsIndexPosition[      6622,        213]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 1.6  .2 . \[IndentingNewLine]using\ 3 - 
        point\ trapezoidal\ rule, \ both\ x0\ and\ s0\ same, \ say\ x0 = 0, \ 
      s0 = 0\ *) \[IndentingNewLine]\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ \(-\ Sqrt[x\ s]\)*
            Log[s], \ \(-\ Sqrt[x\ s]\)*Log[x]];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/100, \ 1/2, \ 1};\)\), "\n", 
    \(\(s = {1/100, \ 1/2, \ 1};\)\), "\n", 
    \(\(matk = 
        Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 3}, {j, 
            3}];\)\), "\[IndentingNewLine]", 
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(a = matk\  . d\), "\[IndentingNewLine]", 
    \(\(c = \[Mu]\ {{1, 0, 0}, \ {0, 1, 0}, \ {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(\(b = a - c;\)\), "\[IndentingNewLine]", 
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)}], "Input"],

Cell[BoxData[
    \({{Log[100]\/400, Log[2]\/\(20\ \@2\), 0}, {Log[2]\/\(40\ \@2\), 
        Log[2]\/4, 0}, {0, 0, 0}}\)], "Output"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 
          0.009677557619911781`}, {\[Mu] \[Rule] 
          0.17512216298504477`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0.009677557619911781`\)], "Input"],

Cell[BoxData[
    \(103.33185699070172`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0.17512216298504477`\)], "Input"],

Cell[BoxData[
    \(5.710299501527964`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ matk\ solved\ analytically\ *) \(matk = {{0, 0, 0}, {0, Log[2]/2, 
            0}, {0, \(-\ Log[2]\)/Sqrt[2], 0}};\)\), "\[IndentingNewLine]", 
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(a = \(\(matk\)\(\ \)\(.\)\(d\)\(\[IndentingNewLine]\)\)\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0}, {0, Log[2]\/4, 0}, {0, \(-\(Log[2]\/\(2\ \@2\)\)\), 
        0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu]\ {{1, 0, 0}, \ {0, 1, 0}, \ {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(-\[Mu]\), 0, 0}, {0, \(-\[Mu]\) + Log[2]\/4, 
        0}, {0, \(-\(Log[2]\/\(2\ \@2\)\)\), \(-\[Mu]\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 
          0.17328679513998632`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0.17328679513998632`\)], "Input"],

Cell[BoxData[
    \(5.7707801635558535`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ using\ 3 - point\ trapezoidal\ rule, \ 
      both\ x0\ and\ s0\ different, \ say\ x0 = 1/100, \ 
      s0 = 0\ *) \[IndentingNewLine]\(k[x_, \ s_] := \ 
        If[x \[LessEqual] \ s, \ \(-\ Sqrt[x\ s]\)*
            Log[s], \ \(-\ Sqrt[x\ s]\)*Log[x]];\)\), "\[IndentingNewLine]", 
    \(\(x = {1/100, \ 1/2, \ 1};\)\), "\n", 
    \(\(s = {0, \ 1/2, \ 1};\)\), "\n", 
    \(matk = 
      Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 3}, {j, 
          3}]\), "\[IndentingNewLine]", 
    \(\(d = {{1/4, 0, 0}, {0, 1/2, \ 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(\(a = matk\  . d;\)\), "\[IndentingNewLine]", 
    \(\(c = \[Mu]\ {{1, 0, 0}, \ {0, 1, 0}, \ {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(\(b = a - c;\)\), "\[IndentingNewLine]", 
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]] // N\)}], "Input"],

Cell[BoxData[
    \({{0, Log[2]\/\(10\ \@2\), 0}, {0, Log[2]\/2, 0}, {0, 0, 0}}\)], "Output"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 0.`}, {\[Mu] \[Rule] 
          0.17328679513998632`}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 904, 17, 219, "Input"],
Cell[2646, 70, 132, 2, 46, "Output"],
Cell[2781, 74, 154, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2972, 82, 56, 1, 27, "Input"],
Cell[3031, 85, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3121, 91, 55, 1, 27, "Input"],
Cell[3179, 94, 52, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3268, 100, 41, 1, 27, "Input"],
Cell[3312, 103, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3391, 109, 344, 5, 107, "Input"],
Cell[3738, 116, 110, 2, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3885, 123, 146, 3, 43, "Input"],
Cell[4034, 128, 141, 2, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4212, 135, 71, 1, 27, "Input"],
Cell[4286, 138, 125, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4448, 145, 55, 1, 27, "Input"],
Cell[4506, 148, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4596, 154, 41, 1, 27, "Input"],
Cell[4640, 157, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4719, 163, 865, 17, 203, "Input"],
Cell[5587, 182, 93, 1, 46, "Output"],
Cell[5683, 185, 125, 2, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

